﻿var exclusions = {
    context: $(".v-exclusions"),
    datatable: null,
    initializeDataTable: function () {
        exclusions.datatable = $(".h-exclusionsTable", this.context).a4datatable({
            height: "full",            
            advancedFilter: true,
            ajaxAction: a4.getAction("GetExclusions", "Distributions", "Settings"),
            columns: exclusions.getColumns(),
            allowRowSelection: canModifyEmailExclusions,
            toolBarItems: exclusions.getToolBarItems(),
            toolBarClick: function (event, data) {
                var rows = data.rows;
                var action = data.action;
                var itemIds = _.pluck(rows, "Id");

                switch (action) {
                    case "delete":
                        exclusions.deleteItems(itemIds);
                        break;
                    case "activate":
                        exclusions.updateItemsState(itemIds, true);
                        break;
                    case "deactivate":
                        exclusions.updateItemsState(itemIds, false);
                        break;

                }
            },
            contextMenuItems: exclusions.getContextMenuItems(),
            contextMenuClick: function (event, data) {
                var row = data.row;
                var action = data.action;
                var itemId = row.Id;

                switch (action) {
                    case "properties":
                        modalDialog.showWindow(a4.getAction("EditExclusion", "Distributions", "Settings", { id: itemId }), 500, 700, { afterClose: exclusions.refreshDataTable });
                        break;
                    case "delete":
                        exclusions.deleteItems(itemId);
                        break;
                    case "activate":
                        exclusions.updateItemsState(itemId, true)
                        break;
                    case "deactivate":
                        exclusions.updateItemsState(itemId, false)
                        break;
                }
            },
            saveState: true,
            stateKey: "EmailExclusionList",
            quickFilter: {
                "Items": [
                    { "Label": resources.Active, "AjaxParams": { "active": true } },
                    { "Label": resources.Inactive, "AjaxParams": { "active": false } }
                ]
            },
            localizableTexts: { "All": resources.AllUnsubscribeContacts, "Search": resources.SearchUnsubscribeContacts }
        });
    },
    bindEvents: function () {
        exclusions.context.on("click", ".h-addEmail", function () {
            modalDialog.showWindow(a4.getAction("EditExclusion", "Distributions", "Settings"), 500, 700, { afterClose: function () { exclusions.refreshDataTable(); } });
        });

        exclusions.context.on("click", ".h-customFields", function () {
            modalDialog.showWindow(a4.getAction("CustomFields", "Distributions", "Settings"), 560, 700, { afterClose: function () { exclusions.refreshDataTable(); } });
        });

        exclusions.context.on("click", ".h-import", function () {
            modalDialog.showWindow(a4.getAction("ImportExclusions", "Distributions", "Settings"), 420, 720, { afterClose: function () { exclusions.refreshDataTable(); } });
        });

        exclusions.context.on("click", ".h-export", function () {
            a4.showBusyBox();

            var tableParams = exclusions.datatable.a4datatable("getTableParams");

            a4.callServerMethod(a4.getAction("ExportExclusions", "Distributions", "Settings"), { tableParams: JSON.stringify(tableParams) },
            function (result) {
                a4.hideBusyBox();
                window.location = a4.getAction("GetExclusionsFile", "Distributions", "Settings", { fileName: result });
            },
            function (error) {
                a4.onAjaxPageMethodError(error);
            });
        });
    },
    refreshPage: function () {
        location.reload();
    },
    refreshDataTable: function () {
        exclusions.datatable.a4datatable("refresh");
    },
    deleteItems: function (items) {
        var itemsCount = items.length;
        if (itemsCount === undefined) {
            itemsCount = 1;
        }

        modalDialog.showConfirmDialog(confirmDeleteItemResources, function () {
            a4.callServerMethod(a4.getAction("DeleteExclusions", "Distributions", "Settings"), { itemIds: items },
                function (result) {
                    exclusions.refreshDataTable();
                });
        }, 250, 500, true, { "count": itemsCount });
    },
    updateItemsState: function (items, active) {
        a4.callServerMethod(a4.getAction("UpdateExclusionsState", "Distributions", "Settings"), { itemIds: items, active: active },
            function (result) {
                exclusions.refreshDataTable();
            });
    },
    getColumns: function () {
        var columns = [{ "Title": resources.Id, "Data": "Id", "Type": "numeric", "Key": true },
                       { "Title": resources.Active, "Data": "Active", "Type": "boolean", "ShowIcon": true },
                       { "Title": resources.Email, "Data": "Email", "HideInSelector": true },
                       { "Title": resources.Phone, "Data": "Phone" },
                       { "Title": resources.SurveyId, "Data": "SurveyId", "Type": "numeric" },
                       { "Title": resources.SurveyName, "Data": "SurveyName" },
                       { "Title": resources.RespondentId, "Data": "RespondentId", "Type": "numeric" }];

        var customFields = JSON.parse($("#CustomFieldsJson").val());

        _.each(customFields, function (field) {
            columns.push({ "Title": field.Name, "Data": "Custom" + field.ColumnNumber });
        });

        columns = columns.concat([{ "Title": resources.CreatedBy, "Data": "CreatedBy" },
                                  { "Title": resources.CreatedOn, "Data": "CreatedOn", "Type": "date" },
                                  { "Title": resources.ModifiedBy, "Data": "ModifiedBy" },
                                  { "Title": resources.ModifiedOn, "Data": "ModifiedOn", "Type": "date" }]);

        return columns;
    },
    getContextMenuItems: function () {
        var items = [];

        if (canModifyEmailExclusions) {
            items.push({ "Action": "delete", "Label": resources.Delete });
            items.push({ "Action": "properties", "Label": resources.Properties });
            items.push({ "Divider": true });
            items.push({ "Action": "activate", "Label": resources.Activate, "DisplayCondition": function (data) { return !data.Active; } });
            items.push({ "Action": "deactivate", "Label": resources.Deactivate, "DisplayCondition": function (data) { return data.Active; } });
        }

        return items;
    },
    getToolBarItems: function () {
        var items = [];

        if (canModifyEmailExclusions) {
            items.push({ "Action": "delete", "Label": resources.Delete });
            items.push({ "Action": "activate", "Label": resources.Activate, "DisplayCondition": function (data) { return !data.Active; } });
            items.push({ "Action": "deactivate", "Label": resources.Deactivate, "DisplayCondition": function (data) { return data.Active; } });
        }

        return items;
    }
}

$(document).ready(function () {
    if (exclusions.context.length > 0) {
        exclusions.initializeDataTable();
        exclusions.bindEvents();
        exclusions.context.trigger("focus");
    }
});